/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.BackgroundTaskDialog;
import de.willuhn.jameica.gui.internal.dialogs.PluginUnInstallDialog;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.plugin.Plugin;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;

public class PluginUnInstall
implements Action {
    private static final I18N i18n = Application.getI18n();

    @Override
    public void handleAction(Object context) throws ApplicationException {
        if (context == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie das zu deinstallierende Plugin aus"));
        }
        Manifest mf = null;
        if (context instanceof Manifest) {
            mf = (Manifest)context;
        }
        if (context instanceof Plugin) {
            mf = ((Plugin)context).getManifest();
        }
        if (mf == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie das zu deinstallierende Plugin aus"));
        }
        Application.getPluginLoader().canUnInstall(mf);
        boolean deleteUserData = false;
        try {
            PluginUnInstallDialog d = new PluginUnInstallDialog(mf);
            Boolean b = (Boolean)d.open();
            if (b == null || !b.booleanValue()) {
                return;
            }
            deleteUserData = d.getDeleteUserData();
        }
        catch (OperationCanceledException oce) {
            return;
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"unable to perform action", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler: {0}", e.getMessage()));
        }
        final Manifest m = mf;
        final boolean d = deleteUserData;
        BackgroundTask task = new BackgroundTask(){

            @Override
            public void run(ProgressMonitor monitor) throws ApplicationException {
                Application.getPluginLoader().unInstall(m, d, monitor);
            }

            @Override
            public boolean isInterrupted() {
                return false;
            }

            @Override
            public void interrupt() {
            }
        };
        try {
            BackgroundTaskDialog bd = new BackgroundTaskDialog(1, task);
            bd.setSideImage(SWTUtil.getImage("user-trash-full.png"));
            bd.setTitle(i18n.tr("Deinstalliere..."));
            bd.setPanelText(i18n.tr("Deinstalliere Plugin"));
            bd.open();
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)"operation cancelled");
        }
        catch (Exception e) {
            Logger.error((String)"unable to uninstall plugin", (Throwable)e);
            throw new ApplicationException(i18n.tr("Deinstallation fehlgeschlagen: {0}", e.getMessage()));
        }
    }
}

